/*
 * DO NOT EDIT.  THIS FILE IS GENERATED FROM $SRCDIR/widget/nsIBaseWindow.idl
 */

#ifndef __gen_nsIBaseWindow_h__
#define __gen_nsIBaseWindow_h__


#include "nsISupports.h"

#include "nsrootidl.h"

/* For IDL files that don't want to include root IDL files. */
#ifndef NS_NO_VTABLE
#define NS_NO_VTABLE
#endif
#include "Units.h"
#include "mozilla/DimensionRequest.h"
class nsIWidget;
typedef void *  nativeWindow;


/* starting interface:    nsIBaseWindow */
#define NS_IBASEWINDOW_IID_STR "ca635529-a977-4552-9b8a-66187e54d882"

#define NS_IBASEWINDOW_IID \
  {0xca635529, 0xa977, 0x4552, \
    { 0x9b, 0x8a, 0x66, 0x18, 0x7e, 0x54, 0xd8, 0x82 }}

class nsIBaseWindow : public nsISupports {
 public:

  NS_INLINE_DECL_STATIC_IID(NS_IBASEWINDOW_IID)

  /* Used by ToJSValue to check which scriptable interface is implemented. */
  using ScriptableInterfaceType = nsIBaseWindow;

  /* [noscript] void initWindow (in nsIWidget parentWidget, in long x, in long y, in long cx, in long cy); */
  NS_IMETHOD InitWindow(nsIWidget * parentWidget, int32_t x, int32_t y, int32_t cx, int32_t cy) = 0;

  /* void destroy (); */
  NS_IMETHOD Destroy(void) = 0;

  /* void setPosition (in long x, in long y); */
  NS_IMETHOD SetPosition(int32_t x, int32_t y) = 0;

  /* void setPositionDesktopPix (in long x, in long y); */
  NS_IMETHOD SetPositionDesktopPix(int32_t x, int32_t y) = 0;

  /* void getPosition (out long x, out long y); */
  NS_IMETHOD GetPosition(int32_t *x, int32_t *y) = 0;

   mozilla::LayoutDeviceIntPoint GetPosition() {
    int32_t x = 0, y = 0;
    GetPosition(&x, &y);
    return mozilla::LayoutDeviceIntPoint(x, y);
  }
  /* void setSize (in long cx, in long cy, in boolean fRepaint); */
  NS_IMETHOD SetSize(int32_t cx, int32_t cy, bool fRepaint) = 0;

  /* void getSize (out long cx, out long cy); */
  NS_IMETHOD GetSize(int32_t *cx, int32_t *cy) = 0;

   mozilla::LayoutDeviceIntSize GetSize() {
    int32_t w = 0, h = 0;
    GetSize(&w, &h);
    return mozilla::LayoutDeviceIntSize(w, h);
  }
  enum {
    eRepaint = 1U,
    eDelayResize = 2U
  };

  /* void setPositionAndSize (in long x, in long y, in long cx, in long cy, in unsigned long flags); */
  NS_IMETHOD SetPositionAndSize(int32_t x, int32_t y, int32_t cx, int32_t cy, uint32_t flags) = 0;

  /* void getPositionAndSize (out long x, out long y, out long cx, out long cy); */
  NS_IMETHOD GetPositionAndSize(int32_t *x, int32_t *y, int32_t *cx, int32_t *cy) = 0;

   mozilla::LayoutDeviceIntRect GetPositionAndSize() {
    int32_t x = 0, y = 0, w = 0, h = 0;
    GetPositionAndSize(&x, &y, &w, &h);
    return mozilla::LayoutDeviceIntRect(x, y, w, h);
  }
  /* [noscript] void setDimensions (in DimensionRequest aRequest); */
  NS_IMETHOD SetDimensions(mozilla::DimensionRequest&& aRequest) = 0;

  /* [noscript] void getDimensions (in DimensionKind aDimensionKind, out long aX, out long aY, out long aCX, out long aCY); */
  NS_IMETHOD GetDimensions(mozilla::DimensionKind aDimensionKind, int32_t *aX, int32_t *aY, int32_t *aCX, int32_t *aCY) = 0;

   mozilla::LayoutDeviceIntRect GetDimensions(mozilla::DimensionKind aDimensionKind) {
    int32_t x = 0, y = 0, w = 0, h = 0;
    GetDimensions(aDimensionKind, &x, &y, &w, &h);
    return mozilla::LayoutDeviceIntRect(x, y, w, h);
  }
  /* void repaint (in boolean force); */
  NS_IMETHOD Repaint(bool force) = 0;

  /* [noscript] attribute nsIWidget parentWidget; */
  NS_IMETHOD GetParentWidget(nsIWidget * * aParentWidget) = 0;
  NS_IMETHOD SetParentWidget(nsIWidget * aParentWidget) = 0;

  /* readonly attribute AString nativeHandle; */
  NS_IMETHOD GetNativeHandle(nsAString& aNativeHandle) = 0;

  /* attribute boolean visibility; */
  NS_IMETHOD GetVisibility(bool *aVisibility) = 0;
  NS_IMETHOD SetVisibility(bool aVisibility) = 0;

  /* attribute boolean enabled; */
  NS_IMETHOD GetEnabled(bool *aEnabled) = 0;
  NS_IMETHOD SetEnabled(bool aEnabled) = 0;

  /* [noscript] readonly attribute nsIWidget mainWidget; */
  NS_IMETHOD GetMainWidget(nsIWidget * * aMainWidget) = 0;

  /* [noscript,nostdcall,notxpcom] readonly attribute double widgetCSSToDeviceScale; */
  virtual double GetWidgetCSSToDeviceScale() = 0;

   // The number of device pixels per CSS pixel used on this window's current
  // screen at the default full zoom level.
  //
  // This is the widget scale _plus_ the OS zoom scale if appropriate.
  // Implemented in AppWindow.cpp
  mozilla::CSSToLayoutDeviceScale UnscaledDevicePixelsPerCSSPixel();
  /* readonly attribute double devicePixelsPerDesktopPixel; */
  NS_IMETHOD GetDevicePixelsPerDesktopPixel(double *aDevicePixelsPerDesktopPixel) = 0;

   mozilla::DesktopToLayoutDeviceScale DevicePixelsPerDesktopPixel() {
    double s = 1.0;
    GetDevicePixelsPerDesktopPixel(&s);
    return mozilla::DesktopToLayoutDeviceScale(s);
  }
  mozilla::CSSToDesktopScale GetUnscaledCSSToDesktopScale() {
    return UnscaledDevicePixelsPerCSSPixel() / DevicePixelsPerDesktopPixel();
  }
  /* attribute AString title; */
  NS_IMETHOD GetTitle(nsAString& aTitle) = 0;
  NS_IMETHOD SetTitle(const nsAString& aTitle) = 0;

};


/* Use this macro when declaring classes that implement this interface. */
#define NS_DECL_NSIBASEWINDOW \
  NS_IMETHOD InitWindow(nsIWidget * parentWidget, int32_t x, int32_t y, int32_t cx, int32_t cy) override; \
  NS_IMETHOD Destroy(void) override; \
  NS_IMETHOD SetPosition(int32_t x, int32_t y) override; \
  NS_IMETHOD SetPositionDesktopPix(int32_t x, int32_t y) override; \
  NS_IMETHOD GetPosition(int32_t *x, int32_t *y) override; \
  NS_IMETHOD SetSize(int32_t cx, int32_t cy, bool fRepaint) override; \
  NS_IMETHOD GetSize(int32_t *cx, int32_t *cy) override; \
  NS_IMETHOD SetPositionAndSize(int32_t x, int32_t y, int32_t cx, int32_t cy, uint32_t flags) override; \
  NS_IMETHOD GetPositionAndSize(int32_t *x, int32_t *y, int32_t *cx, int32_t *cy) override; \
  NS_IMETHOD SetDimensions(mozilla::DimensionRequest&& aRequest) override; \
  NS_IMETHOD GetDimensions(mozilla::DimensionKind aDimensionKind, int32_t *aX, int32_t *aY, int32_t *aCX, int32_t *aCY) override; \
  NS_IMETHOD Repaint(bool force) override; \
  NS_IMETHOD GetParentWidget(nsIWidget * * aParentWidget) override; \
  NS_IMETHOD SetParentWidget(nsIWidget * aParentWidget) override; \
  NS_IMETHOD GetNativeHandle(nsAString& aNativeHandle) override; \
  NS_IMETHOD GetVisibility(bool *aVisibility) override; \
  NS_IMETHOD SetVisibility(bool aVisibility) override; \
  NS_IMETHOD GetEnabled(bool *aEnabled) override; \
  NS_IMETHOD SetEnabled(bool aEnabled) override; \
  NS_IMETHOD GetMainWidget(nsIWidget * * aMainWidget) override; \
  virtual double GetWidgetCSSToDeviceScale() override; \
  NS_IMETHOD GetDevicePixelsPerDesktopPixel(double *aDevicePixelsPerDesktopPixel) override; \
  NS_IMETHOD GetTitle(nsAString& aTitle) override; \
  NS_IMETHOD SetTitle(const nsAString& aTitle) override; 

/* Use this macro when declaring the members of this interface when the
   class doesn't implement the interface. This is useful for forwarding. */
#define NS_DECL_NON_VIRTUAL_NSIBASEWINDOW \
  nsresult InitWindow(nsIWidget * parentWidget, int32_t x, int32_t y, int32_t cx, int32_t cy); \
  nsresult Destroy(void); \
  nsresult SetPosition(int32_t x, int32_t y); \
  nsresult SetPositionDesktopPix(int32_t x, int32_t y); \
  nsresult GetPosition(int32_t *x, int32_t *y); \
  nsresult SetSize(int32_t cx, int32_t cy, bool fRepaint); \
  nsresult GetSize(int32_t *cx, int32_t *cy); \
  nsresult SetPositionAndSize(int32_t x, int32_t y, int32_t cx, int32_t cy, uint32_t flags); \
  nsresult GetPositionAndSize(int32_t *x, int32_t *y, int32_t *cx, int32_t *cy); \
  nsresult SetDimensions(mozilla::DimensionRequest&& aRequest); \
  nsresult GetDimensions(mozilla::DimensionKind aDimensionKind, int32_t *aX, int32_t *aY, int32_t *aCX, int32_t *aCY); \
  nsresult Repaint(bool force); \
  nsresult GetParentWidget(nsIWidget * * aParentWidget); \
  nsresult SetParentWidget(nsIWidget * aParentWidget); \
  nsresult GetNativeHandle(nsAString& aNativeHandle); \
  nsresult GetVisibility(bool *aVisibility); \
  nsresult SetVisibility(bool aVisibility); \
  nsresult GetEnabled(bool *aEnabled); \
  nsresult SetEnabled(bool aEnabled); \
  nsresult GetMainWidget(nsIWidget * * aMainWidget); \
  double GetWidgetCSSToDeviceScale(); \
  nsresult GetDevicePixelsPerDesktopPixel(double *aDevicePixelsPerDesktopPixel); \
  nsresult GetTitle(nsAString& aTitle); \
  nsresult SetTitle(const nsAString& aTitle); 

/* Use this macro to declare functions that forward the behavior of this interface to another object. */
#define NS_FORWARD_NSIBASEWINDOW(_to) \
  NS_IMETHOD InitWindow(nsIWidget * parentWidget, int32_t x, int32_t y, int32_t cx, int32_t cy) override { return _to InitWindow(parentWidget, x, y, cx, cy); } \
  NS_IMETHOD Destroy(void) override { return _to Destroy(); } \
  NS_IMETHOD SetPosition(int32_t x, int32_t y) override { return _to SetPosition(x, y); } \
  NS_IMETHOD SetPositionDesktopPix(int32_t x, int32_t y) override { return _to SetPositionDesktopPix(x, y); } \
  NS_IMETHOD GetPosition(int32_t *x, int32_t *y) override { return _to GetPosition(x, y); } \
  NS_IMETHOD SetSize(int32_t cx, int32_t cy, bool fRepaint) override { return _to SetSize(cx, cy, fRepaint); } \
  NS_IMETHOD GetSize(int32_t *cx, int32_t *cy) override { return _to GetSize(cx, cy); } \
  NS_IMETHOD SetPositionAndSize(int32_t x, int32_t y, int32_t cx, int32_t cy, uint32_t flags) override { return _to SetPositionAndSize(x, y, cx, cy, flags); } \
  NS_IMETHOD GetPositionAndSize(int32_t *x, int32_t *y, int32_t *cx, int32_t *cy) override { return _to GetPositionAndSize(x, y, cx, cy); } \
  NS_IMETHOD SetDimensions(mozilla::DimensionRequest&& aRequest) override { return _to SetDimensions(aRequest); } \
  NS_IMETHOD GetDimensions(mozilla::DimensionKind aDimensionKind, int32_t *aX, int32_t *aY, int32_t *aCX, int32_t *aCY) override { return _to GetDimensions(aDimensionKind, aX, aY, aCX, aCY); } \
  NS_IMETHOD Repaint(bool force) override { return _to Repaint(force); } \
  NS_IMETHOD GetParentWidget(nsIWidget * * aParentWidget) override { return _to GetParentWidget(aParentWidget); } \
  NS_IMETHOD SetParentWidget(nsIWidget * aParentWidget) override { return _to SetParentWidget(aParentWidget); } \
  NS_IMETHOD GetNativeHandle(nsAString& aNativeHandle) override { return _to GetNativeHandle(aNativeHandle); } \
  NS_IMETHOD GetVisibility(bool *aVisibility) override { return _to GetVisibility(aVisibility); } \
  NS_IMETHOD SetVisibility(bool aVisibility) override { return _to SetVisibility(aVisibility); } \
  NS_IMETHOD GetEnabled(bool *aEnabled) override { return _to GetEnabled(aEnabled); } \
  NS_IMETHOD SetEnabled(bool aEnabled) override { return _to SetEnabled(aEnabled); } \
  NS_IMETHOD GetMainWidget(nsIWidget * * aMainWidget) override { return _to GetMainWidget(aMainWidget); } \
  virtual double GetWidgetCSSToDeviceScale() override { return _to GetWidgetCSSToDeviceScale(); } \
  NS_IMETHOD GetDevicePixelsPerDesktopPixel(double *aDevicePixelsPerDesktopPixel) override { return _to GetDevicePixelsPerDesktopPixel(aDevicePixelsPerDesktopPixel); } \
  NS_IMETHOD GetTitle(nsAString& aTitle) override { return _to GetTitle(aTitle); } \
  NS_IMETHOD SetTitle(const nsAString& aTitle) override { return _to SetTitle(aTitle); } 

/* Use this macro to declare functions that forward the behavior of this interface to another object in a safe way. */
#define NS_FORWARD_SAFE_NSIBASEWINDOW(_to) \
  NS_IMETHOD InitWindow(nsIWidget * parentWidget, int32_t x, int32_t y, int32_t cx, int32_t cy) override { return !_to ? NS_ERROR_NULL_POINTER : _to->InitWindow(parentWidget, x, y, cx, cy); } \
  NS_IMETHOD Destroy(void) override { return !_to ? NS_ERROR_NULL_POINTER : _to->Destroy(); } \
  NS_IMETHOD SetPosition(int32_t x, int32_t y) override { return !_to ? NS_ERROR_NULL_POINTER : _to->SetPosition(x, y); } \
  NS_IMETHOD SetPositionDesktopPix(int32_t x, int32_t y) override { return !_to ? NS_ERROR_NULL_POINTER : _to->SetPositionDesktopPix(x, y); } \
  NS_IMETHOD GetPosition(int32_t *x, int32_t *y) override { return !_to ? NS_ERROR_NULL_POINTER : _to->GetPosition(x, y); } \
  NS_IMETHOD SetSize(int32_t cx, int32_t cy, bool fRepaint) override { return !_to ? NS_ERROR_NULL_POINTER : _to->SetSize(cx, cy, fRepaint); } \
  NS_IMETHOD GetSize(int32_t *cx, int32_t *cy) override { return !_to ? NS_ERROR_NULL_POINTER : _to->GetSize(cx, cy); } \
  NS_IMETHOD SetPositionAndSize(int32_t x, int32_t y, int32_t cx, int32_t cy, uint32_t flags) override { return !_to ? NS_ERROR_NULL_POINTER : _to->SetPositionAndSize(x, y, cx, cy, flags); } \
  NS_IMETHOD GetPositionAndSize(int32_t *x, int32_t *y, int32_t *cx, int32_t *cy) override { return !_to ? NS_ERROR_NULL_POINTER : _to->GetPositionAndSize(x, y, cx, cy); } \
  NS_IMETHOD SetDimensions(mozilla::DimensionRequest&& aRequest) override { return !_to ? NS_ERROR_NULL_POINTER : _to->SetDimensions(aRequest); } \
  NS_IMETHOD GetDimensions(mozilla::DimensionKind aDimensionKind, int32_t *aX, int32_t *aY, int32_t *aCX, int32_t *aCY) override { return !_to ? NS_ERROR_NULL_POINTER : _to->GetDimensions(aDimensionKind, aX, aY, aCX, aCY); } \
  NS_IMETHOD Repaint(bool force) override { return !_to ? NS_ERROR_NULL_POINTER : _to->Repaint(force); } \
  NS_IMETHOD GetParentWidget(nsIWidget * * aParentWidget) override { return !_to ? NS_ERROR_NULL_POINTER : _to->GetParentWidget(aParentWidget); } \
  NS_IMETHOD SetParentWidget(nsIWidget * aParentWidget) override { return !_to ? NS_ERROR_NULL_POINTER : _to->SetParentWidget(aParentWidget); } \
  NS_IMETHOD GetNativeHandle(nsAString& aNativeHandle) override { return !_to ? NS_ERROR_NULL_POINTER : _to->GetNativeHandle(aNativeHandle); } \
  NS_IMETHOD GetVisibility(bool *aVisibility) override { return !_to ? NS_ERROR_NULL_POINTER : _to->GetVisibility(aVisibility); } \
  NS_IMETHOD SetVisibility(bool aVisibility) override { return !_to ? NS_ERROR_NULL_POINTER : _to->SetVisibility(aVisibility); } \
  NS_IMETHOD GetEnabled(bool *aEnabled) override { return !_to ? NS_ERROR_NULL_POINTER : _to->GetEnabled(aEnabled); } \
  NS_IMETHOD SetEnabled(bool aEnabled) override { return !_to ? NS_ERROR_NULL_POINTER : _to->SetEnabled(aEnabled); } \
  NS_IMETHOD GetMainWidget(nsIWidget * * aMainWidget) override { return !_to ? NS_ERROR_NULL_POINTER : _to->GetMainWidget(aMainWidget); } \
  virtual double GetWidgetCSSToDeviceScale() override; \
  NS_IMETHOD GetDevicePixelsPerDesktopPixel(double *aDevicePixelsPerDesktopPixel) override { return !_to ? NS_ERROR_NULL_POINTER : _to->GetDevicePixelsPerDesktopPixel(aDevicePixelsPerDesktopPixel); } \
  NS_IMETHOD GetTitle(nsAString& aTitle) override { return !_to ? NS_ERROR_NULL_POINTER : _to->GetTitle(aTitle); } \
  NS_IMETHOD SetTitle(const nsAString& aTitle) override { return !_to ? NS_ERROR_NULL_POINTER : _to->SetTitle(aTitle); } 


#endif /* __gen_nsIBaseWindow_h__ */
